<?php
/*--------------------------------------------------------------------
 ReadServiceInterface.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitWeight\Database\Service;

use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\CombisIdDto;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\WeightDto;
use Gambio\Shop\Properties\SellingUnitWeight\Exceptions\CombisIdDoesNotExistsException;

/**
 * Interface ReadServiceInterface
 * @package Gambio\Shop\Properties\SellingUnitWeight\Database\Service
 */
interface ReadServiceInterface
{
    /**
     * @param CombisIdDto $dto
     *
     * @return WeightDto
     * @throws CombisIdDoesNotExistsException
     */
    public function combinationWeight(CombisIdDto $dto): WeightDto;
}